using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;


namespace CommandBuilder
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Data.Provider.BdpConnection LocalInterbaseConnection;
		private Borland.Data.Provider.BdpCommand bdpSelectCommand1;
		private Borland.Data.Provider.BdpDataAdapter BDPDataAdapter1;
		private Borland.Data.Provider.BdpCommandBuilder BDPCommandBuilder1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.RadioButton radioButton4;
		private System.Windows.Forms.RadioButton radioButton3;
		private System.Windows.Forms.RadioButton radioButton2;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.DataGrid dataGrid1;
		private System.Data.DataSet dataSet1;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.ComboBox comboBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.LocalInterbaseConnection = new Borland.Data.Provider.BdpConnection();
			this.bdpSelectCommand1 = new Borland.Data.Provider.BdpCommand();
			this.BDPDataAdapter1 = new Borland.Data.Provider.BdpDataAdapter();
			this.dataSet1 = new System.Data.DataSet();
			this.BDPCommandBuilder1 = new Borland.Data.Provider.BdpCommandBuilder();
			this.button1 = new System.Windows.Forms.Button();
			this.panel1 = new System.Windows.Forms.Panel();
			this.radioButton4 = new System.Windows.Forms.RadioButton();
			this.radioButton3 = new System.Windows.Forms.RadioButton();
			this.radioButton2 = new System.Windows.Forms.RadioButton();
			this.label1 = new System.Windows.Forms.Label();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.dataGrid1 = new System.Windows.Forms.DataGrid();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.comboBox1 = new System.Windows.Forms.ComboBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.BDPDataAdapter1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).BeginInit();
			this.panel1.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
			this.SuspendLayout();
			// 
			// LocalInterbaseConnection
			// 
			this.LocalInterbaseConnection.ConnectionOptions = "waitonlocks=False;commitretain=False;sqldialect=3;transaction isol" +  
				"ation=ReadCommitted;servercharset=;rolename=myrole";
			this.LocalInterbaseConnection.ConnectionString = "assembly=Borland.Data.Interbase,Version=2.5.0.0,Culture=neutral,Pu" +  
				"blicKeyToken=91d62ebb5b0d1b1b;vendorclient=gds32.dll;database=loc" +  
				"alhost:C:\\Borland\\InterBase\\examples\\database\\employee.gdb;provid" +  
				"er=Interbase;username=sysdba;password=masterkey";
			// 
			// bdpSelectCommand1
			// 
			this.bdpSelectCommand1.CommandOptions = null;
			this.bdpSelectCommand1.CommandText = "";
			this.bdpSelectCommand1.CommandType = System.Data.CommandType.Text;
			this.bdpSelectCommand1.Connection = null;
			this.bdpSelectCommand1.ParameterCount = ((short)(0));
			this.bdpSelectCommand1.SchemaName = null;
			this.bdpSelectCommand1.Transaction = null;
			this.bdpSelectCommand1.UpdatedRowSource = System.Data.UpdateRowSource.None;
			// 
			// BDPDataAdapter1
			// 
			this.BDPDataAdapter1.Active = false;
			this.BDPDataAdapter1.DataSet = this.dataSet1;
			this.BDPDataAdapter1.DataTable = null;
			this.BDPDataAdapter1.SelectCommand = this.bdpSelectCommand1;
			this.BDPDataAdapter1.StartRecord = 0;
			this.BDPDataAdapter1.TableMappings.AddRange(new System.Data.Common.DataTableMapping[] {
						new System.Data.Common.DataTableMapping("Table", "EMPLOYEE", new System.Data.Common.DataColumnMapping[] {
									new System.Data.Common.DataColumnMapping("EMP_NO", "EMP_NO"),
									new System.Data.Common.DataColumnMapping("FIRST_NAME", "FIRST_NAME"),
									new System.Data.Common.DataColumnMapping("LAST_NAME", "LAST_NAME"),
									new System.Data.Common.DataColumnMapping("PHONE_EXT", "PHONE_EXT"),
									new System.Data.Common.DataColumnMapping("HIRE_DATE", "HIRE_DATE"),
									new System.Data.Common.DataColumnMapping("DEPT_NO", "DEPT_NO"),
									new System.Data.Common.DataColumnMapping("JOB_CODE", "JOB_CODE"),
									new System.Data.Common.DataColumnMapping("JOB_GRADE", "JOB_GRADE"),
									new System.Data.Common.DataColumnMapping("JOB_COUNTRY", "JOB_COUNTRY"),
									new System.Data.Common.DataColumnMapping("SALARY", "SALARY"),
									new System.Data.Common.DataColumnMapping("FULL_NAME", "FULL_NAME")})});
			// 
			// dataSet1
			// 
			this.dataSet1.DataSetName = "NewDataSet";
			this.dataSet1.Locale = new System.Globalization.CultureInfo("en-US");
			// 
			// BDPCommandBuilder1
			// 
			this.BDPCommandBuilder1.DataAdapter = null;
			this.BDPCommandBuilder1.ExcludeFilter = null;
			this.BDPCommandBuilder1.QuotePrefix = "";
			this.BDPCommandBuilder1.QuoteSuffix = "";
			this.BDPCommandBuilder1.ReadOnly = null;
			this.BDPCommandBuilder1.UpdateMode = Borland.Data.Common.BdpUpdateMode.Key;
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(8, 408);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(144, 23);
			this.button1.TabIndex = 0;
			this.button1.Text = "Generate Commands";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// panel1
			// 
			this.panel1.BackColor = System.Drawing.SystemColors.ControlDark;
			this.panel1.Controls.Add(this.radioButton4);
			this.panel1.Controls.Add(this.radioButton3);
			this.panel1.Controls.Add(this.radioButton2);
			this.panel1.Controls.Add(this.label1);
			this.panel1.Location = new System.Drawing.Point(8, 56);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(144, 112);
			this.panel1.TabIndex = 5;
			// 
			// radioButton4
			// 
			this.radioButton4.Location = new System.Drawing.Point(8, 80);
			this.radioButton4.Name = "radioButton4";
			this.radioButton4.TabIndex = 8;
			this.radioButton4.Text = "Delete";
			this.radioButton4.Click += new System.EventHandler(this.radioButton4_Click);
			// 
			// radioButton3
			// 
			this.radioButton3.Location = new System.Drawing.Point(8, 56);
			this.radioButton3.Name = "radioButton3";
			this.radioButton3.TabIndex = 7;
			this.radioButton3.Text = "Insert";
			this.radioButton3.Click += new System.EventHandler(this.radioButton3_Click);
			// 
			// radioButton2
			// 
			this.radioButton2.Location = new System.Drawing.Point(8, 32);
			this.radioButton2.Name = "radioButton2";
			this.radioButton2.TabIndex = 6;
			this.radioButton2.Text = "Update";
			this.radioButton2.Click += new System.EventHandler(this.radioButton2_Click);
			// 
			// label1
			// 
			this.label1.AutoSize = true;
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(85, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Command Type";
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(160, 56);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ReadOnly = true;
			this.textBox1.Size = new System.Drawing.Size(344, 112);
			this.textBox1.TabIndex = 6;
			this.textBox1.Text = "";
			// 
			// dataGrid1
			// 
			this.dataGrid1.CaptionForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.dataGrid1.DataMember = "";
			this.dataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGrid1.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.dataGrid1.Location = new System.Drawing.Point(8, 168);
			this.dataGrid1.Name = "dataGrid1";
			this.dataGrid1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.dataGrid1.Size = new System.Drawing.Size(496, 232);
			this.dataGrid1.TabIndex = 0;
			// 
			// textBox2
			// 
			this.textBox2.Location = new System.Drawing.Point(160, 32);
			this.textBox2.Name = "textBox2";
			this.textBox2.Size = new System.Drawing.Size(344, 20);
			this.textBox2.TabIndex = 11;
			this.textBox2.Text = "";
			// 
			// comboBox1
			// 
			this.comboBox1.Items.AddRange(new object[] {
						"Key",
						"All"});
			this.comboBox1.Location = new System.Drawing.Point(8, 32);
			this.comboBox1.Name = "comboBox1";
			this.comboBox1.Size = new System.Drawing.Size(121, 21);
			this.comboBox1.TabIndex = 12;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 8);
			this.label2.Name = "label2";
			this.label2.TabIndex = 13;
			this.label2.Text = "Update Mode";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(160, 8);
			this.label3.Name = "label3";
			this.label3.TabIndex = 14;
			this.label3.Text = "Select Command";
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 438);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.comboBox1);
			this.Controls.Add(this.textBox2);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.dataGrid1);
			this.Name = "WinForm";
			this.Text = "Command Builder Sample";
			this.Load += new System.EventHandler(this.WinForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.BDPDataAdapter1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).EndInit();
			this.panel1.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		private void button1_Click(object sender, System.EventArgs e)
		{

			textBox1.Text = "";

			if (textBox2.Text == "" )
			{
				textBox1.Text = "Enter a valid Select command above";
				return;
			}

			try
			{
				if( LocalInterbaseConnection.State != ConnectionState.Open )
					LocalInterbaseConnection.Open();

				BDPDataAdapter1 = new Borland.Data.Provider.BdpDataAdapter( textBox2.Text, LocalInterbaseConnection);

				BDPCommandBuilder1 = new Borland.Data.Provider.BdpCommandBuilder( BDPDataAdapter1 );
				SetCommandBuilderUpdateMode();

				DataSet ds = new DataSet();
				BDPDataAdapter1.DataSet = ds;

				BDPDataAdapter1.Active = false;
				BDPDataAdapter1.Active = true;

				LocalInterbaseConnection.Close();

				dataGrid1.SetDataBinding(ds,ds.Tables[0].TableName);

				radioButton2.Checked = true;
				SetCommandTextBox();

			}
			catch( Exception f )
			{
				textBox1.Text = "Error Generating Commands. Failed with message: " + f.Message;
			}

		}

		private void SetCommandBuilderUpdateMode(){

			switch ( comboBox1.SelectedIndex )
			{
				case 0:
					BDPCommandBuilder1.UpdateMode = Borland.Data.Common.BdpUpdateMode.Key;
					break;
				case 1:
					BDPCommandBuilder1.UpdateMode = Borland.Data.Common.BdpUpdateMode.All;
					break;
			}

		}

		private void radioButton2_Click(object sender, System.EventArgs e)
		{
			SetCommandTextBox();
		}

		private void radioButton3_Click(object sender, System.EventArgs e)
		{
			SetCommandTextBox();
		}

		private void radioButton4_Click(object sender, System.EventArgs e)
		{
			SetCommandTextBox();
		}

		private void SetCommandTextBox(){

			try
			{
				if( LocalInterbaseConnection.State != ConnectionState.Open )
					LocalInterbaseConnection.Open();

				if (BDPDataAdapter1.SelectCommand != null){
					if (radioButton2.Checked)
						textBox1.Text = BDPCommandBuilder1.GetUpdateCommand().CommandText;
					else if (radioButton3.Checked)
						textBox1.Text = BDPCommandBuilder1.GetInsertCommand().CommandText;
					else if (radioButton4.Checked)
						textBox1.Text = BDPCommandBuilder1.GetDeleteCommand().CommandText;
				}else
					textBox1.Text = "Click Generate Command First";

				LocalInterbaseConnection.Close();
			}
			catch( Exception e )
			{
				textBox1.Text = "An Exception has occurred: " + e.Message;
			}

		}

		private void WinForm_Load(object sender, System.EventArgs e)
		{
			comboBox1.SelectedIndex = 0;
		}

	}
}
